is.prime <- function(n, algorithm="AKS") {
	algorithm <- match.arg(algorithm, c("naive", "Fermat", "MillerRabin", "AKS"))
	switch(algorithm,
		naive=NaivePrimalityTest(n),
		Fermat=FermatPseudoprimeTest(n),
		MillerRabin=MillerRabinPseudoprimeTest(n),
		AKS=AKSPrimalityTest(n)
	)
}

NaivePrimalityTest <- function(n) {
	message("NaivePrimalityTest")
	NULL
}

FermatPseudoprimeTest <- function(n) {
	message("FermatPseudoprimeTest")
	NULL
}

MillerRabinPseudoprimeTest <- function(n) {
	message("MillerRabinPseudoprimeTest")
	NULL
}

AKSPrimalityTest <- function(n) {
	message("AKSPrimalityTest")
	NULL
}

is.prime(13)
is.prime(13, algorithm="Fermat")
is.prime(13, algorithm="MillerRabin")
is.prime(13, algorithm="Miller")
